function [Rv, dv, z] = covariance_compute_1d(design, R)
[diffs, ~, index_map] = weight_function_1d(design);
[s, m_v, zero_idx] = get_central_ula_size(diffs);
z = zeros(s,1);
jj = 1;
for ii=zero_idx-m_v+1:zero_idx+m_v-1
    z(jj) = mean(R(index_map{ii}));
    jj = jj + 1;
end
Rv = zeros(m_v);

        for ii = 1:m_v
            Rv = Rv + z(ii:ii+m_v-1) * z(ii:ii+m_v-1)';
        end
        Rv = Rv / m_v;
dv = ula_1d(m_v, design.element_spacing, 'Virtual ULA');
end

function [DCAs, weight_func, position_index] = weight_function_1d(design)
position_SA = design.element_indices(:);
DCAs = [];
weight_func = [];
position_index = {};
n = length(position_SA);
P = repmat(position_SA', n, 1);
D = P' - P; 
[all_diffs, idx] = sort(D(:));
cur_diff = all_diffs(1);
start_idx = 1;
jj = 1;
for ii = 2:(n*n)
    if all_diffs(ii) ~= cur_diff
        DCAs(jj) = cur_diff;
        position_index{jj} = idx(start_idx:ii-1);
        weight_func(jj) = ii - start_idx;
        start_idx = ii;
        cur_diff = all_diffs(ii);
        jj = jj + 1;
    end
end
DCAs(jj) = cur_diff;
position_index{jj} = idx(start_idx:end);
weight_func(jj) = n*n - start_idx + 1;
end

function [s, m_v, zero_idx] = get_central_ula_size(diffs)

if isstruct(diffs)
    diffs = unique_differences(diffs.element_indices);
end

w = 0;
zero_idx = find(diffs == 0);
n_diff = length(diffs);
while zero_idx + w < n_diff && zero_idx - w > 1
    w = w + 1;
    if (diffs(zero_idx+w) - diffs(zero_idx+w-1) ~= 1) || (diffs(zero_idx-w+1) - diffs(zero_idx-w)) ~= 1
        w = w - 1;
        break;
    end
end
m_v = w + 1;
s = 2*m_v - 1;

end


